### 需求
当A接受【保护B】的协议时，当B被攻击时，A攻击【攻击B的人】。
### 一阶
``` C#
A.接受协议(() => OnExec<释放技能>(t => {
    if(t is I攻击术法 && t.目标 == B){
        A.攻击(t.施法者);
    }
}));
```
有问题：A不仅要保护B，B还要给A钱，并且给A的钱要包含协议签订费、出手费、受伤补贴。现在的结构扩展性太差了。
### 二阶：扩展性
``` C#
A.接受协议(new 协议 {
    甲方 = A,
    乙方 = B,
    规范列表 = [
        X => OnExec<释放技能>(t => {
		    if(t is I攻击术法 && t.目标 == X.乙方){
		        X.甲方.攻击(t.施法者);
		    }
		}),
    ],
});
```
现在扩展性好了，但是还有问题：乙方受伤，甲方必须去攻击吗？
协议中可以规定要攻击，但甲方未必要完全执行协议。目前的架构不支持【甲方不完全执行】，因此还要进一步增加扩展性，思路应当是：
当A接受了规范X后，A会在空闲时关注X的条件是否满足，如果满足，那么A会评估此时执行X的要求的风险与成本，如果可以接受，那么执行X的要求。
X：当B被攻击时，A攻击【攻击B的人】
### 三阶：扩展性，允许不执行
``` C#
A.接受协议(new 协议 {
    甲方 = A,
    乙方 = B,
    规范列表 = [
        new 规范 {
            条件 = X => X.乙方.作战目标 != null,
            行为 = X => X.甲方.攻击(X.乙方.作战目标),
        },
        //加一条：当乙方主动找别人麻烦惹起战争时，协议无效
        //外部：当执行攻击指令时，设置各方的作战目标
    ],
});
```
不过现在引入了【作战目标】这样一个丑陋的东西，它几乎只是为了这个协议而服务的，不好。
尽量让【新增一个协议，就只新增这一个协议的代码，不要修改其他地方的代码】。
对此，可以使用这样的思路：不检查作战目标，只检查是否在战斗中，并由甲方自行判断哪个是敌人。
### 四阶：自行判断敌人
``` C#
A.接受协议(new 协议 {
    甲方 = A,
    乙方 = B,
    规范列表 = [
        new 规范 {
            条件 = X => X.乙方.在战斗中,
            行为 = X => X.甲方.StartTaskList([
                () => new 接近指令 { 发起者 = X.甲方, 目标 = X.乙方 }.Exec(),
                () => X.甲方.StartTaskLine(new TaskLine {
                    //如果已经不在战斗，那么结束
                    OnUpdate = //如果有人攻击乙方、甲方、或乙方攻击某人，那么设置为记忆目标，并结束
                }),
                () => new 消灭指令 { 发起者 = X.甲方, 目标 = X.甲方.读取记忆<保护协议记忆>().敌人 }.Exec(),
            ]),
        },
        //当乙方主动找别人麻烦惹起战争时，协议无效
    ],
});
//调用：A会在空闲时关注规范的条件是否满足，如果满足，那么A会评估此时执行规范的行为的风险与成本，如果可以接受，那么执行规范的行为
```
问：这不还是引入了【在战斗中】这个字段吗？
答：这个字段是一个高复用性的字段，甚至可以直接显示在前台中（Kenshi、环世界等众多游戏中都在前台有此区分），因此内核中可以有它。

问：怎么评估行为是否有风险？
答：基于阅历。维持一个个人阅历列表，如果列表无法否决现在的行为，那么就执行。如果执行结果糟糕，那么就加入到列表里、未来改。
类似的算法有很多：
- DNS解析就是，本地有的话就本地处理，本地没有的话就从互联网获取然后放在本地里
- 踢球也是：有肌肉记忆就用，没有的话就分析处理、然后加入到肌肉记忆
- 细菌免疫也是：遇到病毒就检查病毒库（DNA），没有就当不是病毒，漏网之鱼直接免疫抗，活下来了的话就记录到病毒库里
问：阅历列表的格式是什么？现在的这个协议支持那个格式吗？
答：每一项格式是【在某特性下、做某事、有某结果】。
- 特性可能找错。比如，本该是【敌人强大，我攻击，结果我受伤】，但找成【敌人红衣服，我攻击，结果我受伤】。
- 特性可能矛盾
- 特性可能不被调用。调用是随机的。
- 特性有权重。
这个比较复杂，以后再说吧。现在暂时先用简单粗暴的办法：直接写死【如果敌人太强，那么自己不去保护】。