### 产品介绍
《风神界》，一款名著级游戏，耦合：
- 一款NPC与玩家平权的沙盒开放世界游戏
- 一款以尊敬感为核心的玄幻战略RPG游戏
- 一款关于编程与线性方程组的新教育游戏
- 一款NPC将后天发明语言的虚拟文明游戏
天使轮，需要融资500万元，出让10%股份。预计五年收入100亿元以上。

名著级产品，会耦合多个特性，使得：
- 只看它的任意一个特性，它就可以称得上是一个优秀的产品。（即，爽文加入道理、不是名著级产品，因为只看道理的话它不算优秀产品，它的道理只是锦上添花、不能独当一面。要能独当一面，才算名著。）
- 各个特性的表现是耦合的，无法从表现上分离出某个章节/玩法、使得这个章节只满足一个特性。（即，单纯的缝合拼接，不是名著级产品）
- 每个特性适合不同的用户画像。一个用户在不同的年龄/身份下使用这个产品时的感受不同（因扮演不同的画像）。
名著级产品的商业计划书的写作方式，需要对名著所耦合的特性分条书写。
一般的名著级产品是二特性耦合。《风神界》是四特性耦合，每一个特性都可以独当一面。
### 特性1：一款NPC与玩家平权的沙盒开放世界游戏
**详细信息**
[[虚拟宇宙游戏节奏]]
[[风神界：大争之世]]
**产品特点**
NPC与玩家平权。玩家不会有签到奖励，NPC不会有金钱刷新。NPC要自己在游戏中谋生，玩家开局也不比NPC高贵。生存，建造，战斗，战略，一切玩家能做的事情NPC都能做，一切NPC能做的事情玩家都能做。
**用户画像**
7到30岁，男性，身份为学生或白领（有充足的自由时间），玩过《我的世界》或《EVE Online》或《GTA5》等开放世界游戏。
**市场规模**
2023年全球电子游戏行业市场规模1.18万亿元，并且在不断增长。
**竞品分析**
《EVE》联机平权沙盒开放世界游戏，收入两百亿。但其中没有NPC，只有百万玩家同服。这导致EVE中充斥着剥削，绝大多数玩家都是底层人、光是活着就已经竭尽全力了。玩家之间调侃：【我每天玩EVE，不是因为我多喜欢这个游戏，而是因为：号卖不掉】。
《我的世界（大型服务器）》联机平权沙盒开放世界游戏，《我的世界》整体收入超百亿，上万玩家同服。但由于规则设计的缺陷，导致这里【要么轻松的活着，要么绝望的死去】。因此玩家并不多，之所以有多个上万玩家同服的服务器、纯粹是因为《我的世界（单机版）》的庞大热度引流所致。
**我方优势**
当代不存在玩家与NPC平权的游戏，这是一个空白市场。原因在于这是复杂的跨学科工作：游戏设计、经济学、心理学、人工智能。
玩家与玩家平权的游戏，只需要跨游戏设计与经济学，调控物价。
玩家与NPC平权的游戏，不仅要跨游戏设计与经济学，还需要跨心理学与人工智能，设计好NPC的AI，探究出【具体是人的哪些本质特征，使得人的行为表现满足经济学理论】。
我们团队的每个人都精通学习方式与思维方式，都是跨学科的人才，已掌握游戏设计、经济学、心理学、人工智能相关知识，能够完成此项目。
### 特性2：一款以尊敬感为核心的玄幻战略RPG游戏
**详细信息**
[[风神界：尊敬感]]
**产品特点**
战略PRG：有领主，有平民，每个单位都是一个玩家或AI。对领主而言，平民不是数字；对平民而言，你可加冕为王。玩家要从一个平民开始，在这个世界中凭借自己的聪明才智来积累财富、强化武力、讨伐逆贼、登临王位。
玄幻题材：中国文化出海。当今玄幻修真题材的游戏很少，但玄幻受众广阔，这也是一个巨大的市场空白。
尊敬感：装逼打脸，让原本高高在上的人点头哈腰，让他人做你想让他做但他不愿做的事。
**用户画像**
第一类，16到50岁，男性，身份为学生或白领或蓝领（社会中低层人群），渴望支配他人。
第二类，16到35岁，男性，身份为富二代或官二代，对【人们只凭他父母而尊敬他、不因他本人而尊敬他】而有不甘。
第三类，7到35岁，男性，身份为学生或白领（有充足的时间），看过大量玄幻修真题材的小说或动漫，幻想自己在异世界做各种事。
**竞品分析**
《文明6》：战略游戏，收入十亿。玩家扮演统治者，建设国家、争霸天下。但这里的士兵都是数字，玩家无法体会士兵的心情。
《骑马与砍杀2》：战略游戏缝合RPG游戏，收入十亿。虽然有RPG的部分，但割裂，玩家成为领主后的下属与曾经RPG时期的自己完全不同，下属依然是僵硬的木偶；并且充斥着大量不可招募的剧情NPC。
《KenShi》战略RPG游戏，收入两亿。但这里的NPC非常蠢。玩家后期无敌，孤独寂寞。
**我方优势**
- 精通玄幻小说。大量阅读，并且玄幻小说写作教程帖在贴吧数千楼精品贴。
- 精通心理学，对尊敬感的本质的剖析非常深刻。
- 精通人工智能，能够设计出优秀的AI NPC。
### 特性3：一款关于编程与线性方程组的新教育游戏
**详细信息**
- 游戏设计理论（入门）：[[【普通游戏设计理念】【忽视】]]
- 游戏设计理论（进阶）：[[【普通游戏设计理念】【忽视、毕业、使用】]]
- 游戏设计理论（高阶）：[[【学术游戏设计理念】【降阶】]]
- 游戏设计理论指导思想：[[学习方法：降阶法]]
**产品特点**
游戏上瘾本质是学习上瘾，只不过玩家在传统游戏中学到的是在现实中无用的知识。
极致的教育就是极致的游戏，极致的游戏就是极致的教育。
理科知识的教育的关键在于，九成的内容要用于让玩家产生学习的目的，实现的办法是游戏中存在成百上千个【你简单操作，轻松80分；你费大力突破，实现90分】的需求，此时玩家自己会选择一个需求去钻研。
新教育游戏将引发教育革命，当我们的游戏引起众多模仿者时，学校教育与在线教育都将被取缔，万亿市场。
**用户画像**
7到80岁的男女，对自己感兴趣的事情有过钻研。
**市场规模**
全球教育科技行业市场就超过了一万亿元，每年中国教育补贴两万亿元，教育市场预估在十万亿元以上。
**竞品分析**
- 仿真类功能游戏：此类游戏的游戏性很差，学习目标是游戏强制赋予玩家的，而不是玩家自己决定的。
- 传统教育与在线教育：无法激发学生的学习兴趣。
**我方优势**
- 对心理学的研究超越时代。我们不是把游戏与学习给捏合到一起，而是从理论上意识到【游戏上瘾的本质是大脑的学习机制】【学校学习被大脑判定为不是学习】。
### 特性4：一款NPC将后天发明语言的虚拟文明游戏
**AGI理论详细信息**
- 从案例到浅显原理：[[【通用人工智能原理】【记忆】：基于番茄小说《异兽迷城》]]
- 从案例到深层原理：[[忆苦饭]]
- 从案例到心理学解释到深层原理：[[自我认知：从三请三辞看人脑原理]]
- 从案例到浅显原理，然后展望深层：[[通用人工智能算法（二）：说谎与鉴谎-R]]
- 基于我们的理论，预言裂脑人现象：[[基本三观：否决器]]
- 基于我们的理论，预言裂脑人现象：[[深入讨论裂脑人案例]]
- 我们的研究方法（简单描述）：[[内觉迭代法：AGI的一种实现方式]]
- 我们的研究方法（复杂描述）：[[何谓自我认知与内觉]]
**产品特点**
NPC在出生时如婴儿一样无知，后天在游戏中成长。
整个游戏不需要玩家。
开局之前，后台演变百万年，游戏世界中的NPC们构成社会、发明语言，不同地区的NPC有不同的风俗、文化、语言。NPC会写书，会研究数学、哲学。NPC的智力比肩甚至超越人类。
百万年后，玩家进入这个虚拟文明。
**用户画像**
- 语言学家：研究NPC的语法规则与语言形成
- 哲学家，7到80岁对哲学感兴趣的人：尝试与NPC交流
- 人工智能研究者：测试AGI
- 政府人员：评估AGI
- 财务自由者：脱离现实，永久生活在虚拟文明中
**市场规模**
AGI将会改变所有行业，包括建筑、航天、科研、军事等。这将如同蒸汽机的发明一样，其应用的市场规模将达到数百万亿元级别，比肩人类总价值。
**竞品分析**
- 大模型：死路。不可解释，而且无法在出厂后成长。
- 符号主义：不可能首发实现AGI。（遥远未来中，强人工智能会发明包含对系统本身的自我修正的复杂算法，可以基于符号主义推理系统实现超人工智能。）
- Nars：不可能实现类人AGI。它以概念为原子，但人类意识中概念不是原子。
**我方优势**
- 从心理学入手研究人工智能，使用内觉法改进心理研究方法，拥有数千研究文档，提出一套理论，解释各种人类现象。
### 当前进度
技术积累已完成：
- 游戏设计理论：执悲今厄，千里未来。拥有数百篇原创研究文档，囊括爽的本质、玩法创新量产方法、数值设计理论、经济学社会学政治学与虚拟文明游戏的融合。
- 编程知识：执悲今厄，天涯剑歌，伊利菌。开发过论坛网页、单机游戏、联机游戏，拥有一个五万多行的原创代码库、囊括了前后端全栈，原创与印证了诸多编程架构理论。
- 意识理论：执悲今厄，浊浪逝风，看山。拥有数千篇研究文档，拆解了数千人类行为案例，提出了一套从框架到细节的理论、可以解释人类
- 世界观设计：执悲今厄，暮已归人。读过大量的玄幻小说，经常幻想原创世界观，广度与深度都非常丰富。对风神界的世界观设计有数十万字的文稿，还有更多的在脑内。
- 营销：执悲今厄，忘忧草，仙世凡生。B站抖音小红书众多百万播放视频，知乎众多万赞文章。

DEMO已初步完成。
我们目前的DEMO，主要表现在AI的自主行动方面。
我们的AI有几个特点：自主生存，听驱不听使，学习与记忆。下面分别介绍。
- 自主生存。将AI放在野外，因为饥饿需求，他会采集果实食用，采集木头搭建房屋，种植农田。当遇到敌人时，会躲在房屋里。
- 听驱不听使。我们控制一个新的角色，对AI提议让他跟我们走，他不听。攻击他、禁锢他，再提议让他跟我们走，他表示会听。解除禁锢后，他会跟我们走，但随时可能逃跑。
- 学习与记忆。我们带着AI来到城市，购买了优质的食物，给他吃。他表示非常开心。然后我们将AI瞬移到野外。AI不再盖楼种地，而是采集了一些食物后就开始四处移动，寻找城市。他记得之前城市中有美食。

后续我们将制作如下特点：
- 后天分工、金融发达。如果一个商人AI的货物被海盗打劫了，那么这个商人可能崩溃之下转行做海盗；如果一个猎魔人AI受伤后发现疗伤药很贵，那么这个猎魔人可能转行学炼丹。大量AI在细分领域工作，通过社会贸易来合作，贸易中心的每日商品交易量数以亿计，价格由市场决定。这又催生出一批投机AI，低买高卖来盈利。
- 王朝争霸、权力斗争。见于[[虚拟宇宙游戏节奏]]。
### 开发计划
- 2022.09.30：官网发布，用户可以提问题、读文章。用于学习编程，打通前后端技术栈。（已完成）
- 2022.12.30：官方软件发布，用户可以使用软件提问题、读文章。用于学习C++ Windows编程技术。（已完成）
- 2023.03.30：完成《风神界》的大量碎片，包括移动、攻击、采集、食用、装备、购物等；基于Unity，学习了渲染、动画、3D、数据库等各项技术。但意识到缺乏一个系统的架构来串联碎片。（已完成）
- 2023.06.30：官方软件2.0版本发布，使用Unity重构客户端。并且基于Unity制作前端库，包括目录树、选项卡、右键菜单等，拥有一个两万行的、系统的、代码优雅的、原创的前端库。（已完成）
- 2023.09.30：完成内部软件，以话题为单位进行交流，便于回看历史、搜索、整理。（已完成）
- 2023.12.30：完成游戏《方案之困》，一款挂机战斗小游戏。用于研究游戏架构。但未发布，因为前期数值与新手引导有问题，写了好几份研究文档、改了好几版设定也没解决。而且由于我们设定庞大，每一次改动数值都很高成本。（已完成。架构已清晰，有五万行的原创前后端全架构库，可以基于此架构、通过填充一个个模块来量产游戏）
	- 相关资料：[[游戏研究：挂机游戏好玩的本质是什么？]] 
	- 相关资料：[[如何设计地图使得地图能够让玩家钻研]] 
	- 相关资料：[[游戏研究：从CPU看角色设计]] 
	- 相关资料：[[游戏设计：强度系统划分]] 
	- 相关资料：[[游戏设计：论游戏节奏中的速度]] 
	- 相关资料：[[方案之困：游戏简介]] 
	- 相关资料：[[项目：游戏流水线]] 
	- 相关资料：[[风神界：流派与时间碎片]] 
	- 除了上面的通用研究文档之外，此外还有上百张专用设定表，五千多个具体的专用道具设定，十多个专用数值总纲表，十万字上百节的专用背景故事。
- 2024.03.30：重构游戏《方案之困》，原创设定编辑器，使用公式来生成设定表，基于编译原理、使用表达式树来解析设定表（我们允许列为字符串描述的函数），用于低成本修改数值。但依然改不好数值，于是计划做一款轻量级游戏研究数值。（已完成）
- 2024.06.30：发布游戏《超级扫雷》，一款轻量级游戏，精心研究了数值设计，但体验还是一般（比方案之困好）。我们对此进行了深入反思，意识到是新手教程与bug的问题，这会在二代中改进。（已完成）
	- 相关资料：[[从超级扫雷的数值设计看数值设计师所需的能力]] 
- 2024.09.30：发布官网2.0版本，包含商业计划书、更新日志。参与数十场会议，迭代商业计划书写作方式。（已完成）
- 2024.12.30：发布软件3.0版本，基于原创的类EVE选项卡UI架构、融合了内部软件与公开软件，引入权限管理。（已完成）
- 2025.03.30：发布游戏《超级扫雷2》。计划：验证新版数值设计与新手教程理论。单价10元，预计评价一千、销量三万、收入三十万。
	- 具体规划：[[超级扫雷二代：任务模式]] 
- 2025.06.30：发布游戏《风神界：战斗》。挂机战斗游戏，基于方案之困。为风神界提供战斗系统的库。单价30元，预计评价一千、销量三万、收入一百万。
- 2025.09.30：发布游戏《风神界：建造》。生存建造游戏，类似异星工厂。为风神界提供2D系统的库。单价30元，预计评价一千、销量三万、收入一百万。
- 2025.12.30：发布游戏《风神界：战略》。战略管理游戏，类似钢铁雄心。为风神界提供战略系统的库。单价100元，预计评价一千、销量三万、收入三百万。
- 2026.12.30：发布游戏《风神界》。核心游戏，单机虚拟文明游戏，类似KenShi。单价100元，预计评价三万、销量百万、收入一亿。
	- 相关资料：[[虚拟宇宙游戏节奏]] 
	- 具体规划：[[风神界游戏开发：里程碑]] 
- 2028.12.30：发布游戏《风神界：势力永生》。二代核心游戏，网络虚拟文明游戏，类似EVE。订阅每月100元，预计百万订阅、年入十亿；同时带火单机版游戏，加上DLC、私服租赁、交易税与皮肤、局域网联机版，总年入五十亿。
	- 相关资料：[[风神界：大争之世]] 
	- 相关资料：[[风神界：尊敬感]] 
- 2030.12.30：发布游戏《风神界：创世》。AGI，世界政局动荡。算法与公司一起卖给国家，我们退出。
### 风险分析
- [[质疑：这需要的算力太庞大了，不可能实现]] 
- [[质疑：这游戏有人买吗？玄幻题材玩家太少]] 
- [[质疑：这游戏有人买吗？订阅每月一百太贵]] 
- [[质疑：你们团队资历太差。没学历、没经验]] 
- [[质疑：特性没用。你们游戏设计能力不专业]] 
- [[质疑：你们会遇到技术问题]] 
- [[质疑：你们会遇到管理问题]] 
- [[质疑：你们会遇到营销问题]] 
- [[质疑：名著？狂妄。]] 
### 股权结构
我们大改了传统公司章程：
- 对于投资人，使用股份模式。
- 对于员工，使用工资模式。
- 对于董事会，使用【上交+决议】模式。
**股份模式**
如果获得投资，例如【融资500万元，出让10%股份】，那么分红时将收入的10%分给投资人。
股份只代表分红权，不代表决策权。公司的最终决策权永远属于董事会。投资人不入董事会。
**工资模式**
员工工资从公司账户支出。
**上交决议模式**
上交：
- 可以直接上交现金，进入公司账户。记【某年某月某日，某人上交XX元】。
- 在一个项目开启之前，约定此项目的责任划分以及收入比例划分，例如【我负责设计，你负责实现，我60%，你40%】。当此项目的收入进入公司账户时，记【某年某月某日，公司收入10万元，其中我上交六万，你上交四万】。
- 有一个在线账本，可以浏览上交历史、总计。
决议：
- 一名董事会成员可以提交提案、发起决议，所有董事会成员参加、投票：强支持、支持、弃权、反对、强反对。投票后可讨论，讨论后重新投票，最终按【先对比强支持与强反对，票数一致则看支持与反对，票数还一致则看CEO】。（强表示L3，弱表示L4，等级报告的真实性是L2级准则）
    - L1不满：血海深仇。
    - L2不满：逐出团队/即将逐出。对待父母，则是离家出走；对待爱人，则是即将离婚。
    - L3不满：严肃，生气，几个月以后还会想起来这件事、生气。你不来给我消除的话就是我的心结，终生影响我对你的看法。
    - L4不满：可以忍，如果后续不重演的话会淡忘。比如第一次犯错我饶了你；或者这个事我可以答应、但我想告诉你我并不喜欢它。
- L2级观点的冲突必须通过讨论来降级，无法降级时由CEO决定决议结果。特别的，当CEO有L2观点且无法降级时，按CEO的观点执行。（目前数年历史，还未存在过不可通过讨论降级的L2冲突，甚至不存在不可通过讨论降级的L3冲突）
- 讨论时，参考【这个提案本身如何】【账本的上交历史】【决议历史（这个人申请几次支出了、都拿钱干什么了、结果如何）】。
- 决议通常是如下内容：
    - 当项目进行中，要修改责任划分与收入比例时，决议（不含员工。员工收入是工资，无比例）。
    - 当一名董事会成员需要大额支出时，决议。
    - 当一名董事会成员希望增加或减少团队固定支出时（如雇人），决议。
    - 提案分红。提案者表达每个人分得的量，讨论中可以修改。（计入账本，分多了会导致未来决议时不重视你的观点）
- 账本中记录支出历史、决议历史。每次决议可以附带标记，标记例如【某人对赌XX】【某人平XX元（即，视为少上交XX元。表达支付代价，用于在讨论中让别人不再反对他所支持的观点）】。
当前生效的决议：
- 永续条款：每月初，每名董事银行卡余额补至1000元。
### 董事会成员
董事会成员，平均每人每天核心工作时间3小时，探索时间9小时（包括交流、会议、学习、思考），洗漱吃饭健身3小时，睡眠9小时。
- 执悲今厄：男，24岁，高二停课。冷静理性。目标是通用人工智能、永生、机械改造、遨游星海。
    - 擅长分析问题。对人脑原理、小说/文章写作、游戏设计、视频节奏设计、编程架构等领域有诸多原创理论。
    - 负责变声器项目咨询，变声器项目收入5%以执悲今厄名义上交。
    - 负责游戏项目咨询，游戏项目收入10%以执悲今厄名义上交。
    - 负责《三明治效应在多数时有效的原因与一种稳定培养三明治效应的反例的方式》论文主要内容提供与最终审核，作为第一作者。
    - 负责图书项目大纲与最终审核，项目收入30%以执悲今厄名义上交。
    - CEO，团队组建者
- 千里未来：女，24岁，大二退学。开朗但有所保留、心思多。目标是维持现状：有热闹的团队、工作有价值而不累。因为团队不断进步，所以维持现状需要个人不断进步。
    - 会分析，懂人脑原理。玩过大量游戏，结合分析与人脑原理，有原创游戏设计理论。（分析：提炼游戏优缺点后追问叩问）
    - 负责《超级扫雷》、《文字生存》、《风神界：战斗（原 方案之困）》等小游戏的策划稿与数值设计，小游戏项目收入30%以千里未来名义上交。
    - CEO的高中同学，2015年认识，2020年加入。
- 暮已归人：男，20岁，初中毕业。略自闭。目标是沉浸在虚拟文明游戏中体验。（上级：在地球掌权。下级：想象自己在虚拟文明游戏中）
    - 会分析，懂人脑原理。有原创写作理论。
    - 负责《生成判断论》《超人工智能：过去、现在、未来》图书正文书写，图书项目收入70%以暮已归人名义上交。
    - 负责游戏世界观设计，游戏项目收入10%以暮已归人名义上交。
    - CEO的贴吧粉丝，2017年认识，2020年加入。
- 浊浪逝风：女，31岁，本科毕业。外冷内热。目标是远离浑浊的社会、寻求内心的宁静。
    - 数学与金融专业。会分析，会编程。有原创人脑原理理论。原单位月薪过万。
    - 研究并分享人脑原理。对于除执悲今厄外的所有人：当以他们的名义上交时，其中10%改为以浊浪逝风名义上交。
    - CEO的知乎粉丝，2019年认识，2020年加入。
- 仙世凡生：女，22岁，高中毕业。天真，勤快。目标是参与一个划时代的项目。
    - 会分析，懂人脑原理。
    - 做人际交流研究，包括社群运营、商务合作。
    - 负责官网更新日志页的书写。
    - 负责多平台同步更新文章/视频。
    - 负责游戏的申请、打包、更新上传，小游戏收入的5%以仙世凡生的名义上交。
    - 负责变声器客服，工资由忘忧草以现金支付。
    - CEO的知乎粉丝，2019年认识，2020年加入。
- 天涯剑歌：男，28岁，本科毕业。爽朗。无目标：荣华富贵喜欢，机械改造也喜欢，一无所有也接受。
    - 会分析，懂人脑原理，精通编程与编程架构。
    - 研究并分享编程知识与编程架构理论，无偿。读书学习各科知识：经济、政治、数学、物理。
    - 负责官网的开发与维护。当虚拟文明游戏/通用人工智能获得投资后，视为投资款的10%以天涯剑歌的名义上交。虚拟文明游戏项目的2%收入以天涯剑歌的名义上交。
    - 负责内部聊天软件的审核与规划（由员工开发）。对于其他人：当以他们的名义上交时，其中5%改为以天涯剑歌名义上交。
    - CEO的一名知乎粉丝的朋友，2021年认识，2021年加入。
- 忘忧草：男，19岁，高二退学。常大喜大悲，但可瞬间严肃。目标是被认可、不被他人掌控命运，追求金钱权势。
    - 会分析，懂人脑原理，会编程。有原创视频设计理论。
    - 负责变声器项目视频营销、软件规划。此项目使用独立公司。此项目收入60%属于独立公司，30%以忘忧草名义上交。项目成本独立公司负责。
    - CEO的知乎粉丝，2021年认识，2022年加入。
- 伊利菌：男，20岁，大一休学。内心赤诚，但不会与理性者打交道（在学）。目标是做出伟业，名垂千古。
    - 会但很少分析，懂人脑原理，会编程。
    - 提供场地。每月记账：公司支出3000元给伊利菌、然后以伊利菌名义上交3000元。
    - 负责风神界DEMO制作。当虚拟文明游戏/通用人工智能获得投资后，视为投资款的10%以伊利菌的名义上交。
    - 负责变声器软件制作，忘忧草支付其现金工资，变声器项目收入5%以伊利菌名义上交。
    - CEO的知乎粉丝，2020年认识，2022年加入。
- 看山：男，22岁，大三休学。坚毅。目标是做出光速飞船、遨游宇宙。
    - 会分析，懂人脑原理，会写论文。物理学专业，喜欢人脑原理。
    - 负责《三明治效应在多数时有效的原因与一种稳定培养三明治效应的反例的方式》论文正文，作为第二作者。
    - CEO的知乎粉丝，2019年认识，2024年加入。
- 田嘉豪（预备）：男，31岁，单身无牵挂，线下工作。多听多看多做少说。目标不定，接受平凡的生活、但保留对大事业的渴望。
	- 在北京解放军总医院有七年全栈工程师经验，原单位月薪税后两万；使用Unity开发过独立游戏。
	- 负责游戏开发。暂定月薪税前8000。
	- 面试者，喜欢项目与团队、希望未来能加入董事会。2024年认识，2024年入职、双向考查，旁听董事会决议且允许参与讨论。（我们考察他，他也考察我们）
### 融资计划
融资500万元，出让10%股权。
其中，人员工资350万，场地设备100万，会员专利20万，营销合作30万。
我们会扩招更多的程序员，使用任务模式管理：立项时，执悲今厄对每个项目制定一个全局规划，包含一系列分解任务。项目推进时，执悲今厄对接所有员工、检查旧任务、发布新任务。董事会成员提供执悲今厄需要的资料与任务草案，或直接代为负责对接员工、执悲今厄监督。
如果获得投资，那么我们会砍掉三个风神界小游戏的计划，在超级扫雷2取得成功后直接开始单机虚拟宇宙的制作。
### 联系方式
QQ：1181807822（执悲今厄）
邮箱： 1181807822@qq.com