## 第一章：概念
AGI，通用人工智能，是指像人一样、能够从事任何工作的人工智能。
当代的人脸识别程序、阿尔法狗（围棋人工智能），都是专用人工智能。
AGI会极大的改变时代，带来科技的爆炸式进步。能源无限（聚变发电）、永生、记忆芯片（过目不忘）、星际航行、智能家居与全套佣人，都会迅速实现。但同时，战争与病毒的风险也会扩大。
## 第二章：公理
### 唯物公理
此公理有多种等价形式。如下：
- CLASS公理：AGI可以等价为一个CLASS，拥有一些字段（例如记忆）、拥有一些函数（例如动作）。
- 唯物公理：灵魂不存在，意识是物质的、是大脑中各原子相互作用的宏观表现。意识上传、意识复制是可行的。
### 婴儿公理
此公理有多种等价形式。如下：
- 婴儿公理：AGI必须是婴儿，不含任何先天知识。而不可以是一个成人（GPT是成人）。这个婴儿应当能在一个时间不可逆的环境中，在有限的经验下成长为成人。
- 学习公理：要判断一个东西是否是AGI，不是看他能做到什么（不要看图灵测试），而是看他是否具备强大的后天学习能力。
- 双天公理：一个人所拥有的每一个能力，做出的每一个行为，背后都有且只有两个因素：先天因素，后天因素（经验）。明确一切先天因素之时，就是AGI的实现之时。（修订者注：可以通过【基于一个初始先天态，迅速验证它是否正确，且如果不对那么能够让它变得更接近正确，然后再次验证……】来得到一切先天因素。具体见于第三章）
### 游戏公理
此公理有多种等价形式。如下：
- 游戏公理：AGI未必只能在现实世界中创造与运行。某些特殊的游戏世界中也可以创造出AGI，然后可以将它的数据直接上传到现实机器人中、一段时间的适应之后它自然就能使用机器躯体，不需要修改代码。（修订者注：基于学习公理来判断是否在游戏世界中制造出了AGI）
- 决策公理：AGI可以没有视听觉（而是其他的输入，例如神识感知周围的一切），可以没有肌肉运动（而是其他输出，例如游戏中玩家可以执行的那些离散指令），只需要拥有【对输入的处理能力】。处理包括记忆与输出。（修订者注：对输入的处理能力，就是决策能力）
### 时刻公理
此公理有多种等价形式。如下：
- 时刻公理：AGI并不是【输入-思考-输出，输入-思考-输出……】。而是【时刻输入，时刻思考，时刻输出】，三者并行，而非等待同步。（这可以解释：为什么人闲不住）（修订者注：因为输入系统不工作时，思考与输出系统依然在工作）
- 线程公理：输入、思考、输出，三个线程，共用记忆。三个线程都是【读取记忆，修改记忆】，通过记忆的中转来实现线程之间的通讯。线程之间无法直接通讯。（这可以解释：为什么人难以自我认知？因为许多行为是无意识的、输出线程自发的行为，且意识的思维线程无法直接调用输出线程，只能从记忆中尝试推理出输出线程的操作。）
## 第三章：研究方法
内觉迭代法。
逻辑可得，基于唯物公理、婴儿公理、游戏公理，只要再满足以下三个条件，那么就能实现AGI：
1. 我能正确预测【一个先天算法与人类一样的东西，在拥有某些后天经验时，在某个环境下不会做出怎样的行为】。对后天经验与环境知晓的越具体，预测的【不会做的行为】就越多。极限时可以通过对【各个不会做的行为】的集合取补集而得到【必然唯一做的行为】。（例：一个嚣张的恶霸欺负同学时，不会因为同学的大道理式批评而忏悔。但可能因为同学的反杀与大道理式批评而做出忏悔的行为。）
2. 当我预测【一个先天算法与人类一样的东西，在拥有某些后天经验时，在某个环境下不会做出某种行为】、且一个【我知晓其先天算法与后天经验】的东西（K）在此环境做了这个行为，那么我能得出一个先天算法细节T、满足【人类的这个行为在“双天公理”下的先天因素中有T，且K的先天算法中没有T】。
3. 有一个与地球类似的游戏环境，其物理规则可以与地球不同、但它可以让许多人永恒生活在其中而不觉得枯燥（例如玄幻世界观/科幻世界观下的小说中的世界）。这个环境可以以【地球一秒，游戏内千年】的速度运行，且拥有完善的历史记录、程序员可以宏观或微观的查看千年历史乃至人物历史。（修订者注：当代除EVE之外的各个游戏都无法让人们永恒在其中而不枯燥。）

基于这三个条件，以这样的流程就可以实现AGI：
- 首先，在第一个服务器中，对玩家们发布这个游戏环境，收集玩家们的游戏行为。类似于EVE（EVE被誉为第二地球，玩家们百万人同服、拥有复杂的成员关系。一切历史由玩家书写，官方仅提供世界环境、仅销售月卡）。
- 然后，在第二个服务器中，将第一服务器的玩家们的行为写成行为树、投放一万个行为树AI到新的世界中，然后投放一个初代AGI程序（调整：给行为树中加上对孩子的照顾。将初代AGI作为一个行为树AI的孩子），运行、一秒千年。
- 然后，看历史，观察这个初代AGI的发展历程，对于其中违背预测的部分，得出新的先天因素T（修订者注：基于第二条件），然后修改初代AGI算法，再次【新建世界，一秒千年】。如此迭代，直至没有预测失败的部分。（修订者注：此时AGI研发成功）
这就是内觉迭代法。

初代AGI使用五大系统（基于时刻公理）。
![[五大系统.png]]
## 第四章：目前难点
目前难点在于：
第一，【内觉迭代法】三大条件的第三条，可快速迭代的游戏环境。这个环境本身的代码需要大概三十万行，目前只完成了八万行，需要雇一些程序员来完成；这个环境的服务器成本也需要上千万。
第二，文档整理。【内觉迭代法】三大条件的前两条都不算难，我有数千个研究文档。但这些文档需要整理、避免【重复造轮子】：许多文档的内容我已经遗忘了，我可以重新推导出来，但这样成本会较高，且这种遗忘会不利于我【组合一些文档而出更抽象且本质的先天算法】。

这些问题都可以通过钱解决。
游戏环境的搭建，大约需要三个月薪三万的程序员开发半年，六十万元。
服务器一千万。
文档整理，可以招募一个心理学专业的大学生或研究生整理，月薪两万。

这款游戏本身的收入预计在一亿到一百亿（盈利方式如同EVE，月卡制。EVE收入：二十年，一百亿）。
AGI研发成功后，专利费收入预计万亿。
## 第五章：接受质疑
接受如下质疑：
- 逻辑质疑：我（质疑者）认为，即便满足三大公理与三大条件，内觉迭代法也无法实现AGI。
- 公理质疑：我认为，某个公理不成立。
- 条件质疑：我不认为你满足某个条件。你需要提供更多的证据来证明你满足它，或者完成我的试题来证明你满足它。
- 收入质疑：我认为，即便实现AGI，也无法带来万亿收入。
- 股权质疑：我怀疑，即便你实现万亿收入，我也无法获得千亿分成。
我可以进一步回答。