## 封面
作者：天涯剑歌，浊浪逝风
修订：仙世凡生
终审：执悲今厄
时间：2024.8.30
## 摘要
本文基于[[学习方法：降阶法]]，从另一个角度对降阶法做出了诠释。并且以图片与性质的形式对【指数进步】与【线性进步】提出了一种区分标准。
本文不仅介绍了降阶法，还从人脑原理的方面解释了降阶法高效的本质。
### 标签
#关键词/哲学
#关键词/学习方法
#关键词/指数进步
#关键词/降阶法
#关键词/瞪眼法
#关键词/人脑原理
#关键词/学习机制
#关键词/生成判断：联想机制
#关键词/记忆库整理机制
## 正文
如何学习一项新的技能？（例如编程技能）
降阶瞪眼法。
不要读书。要直接以此技能的后置项目为目标，然后将你的目标分解为一系列指数节点目标，使得满足归纳性：
- 第一个节点是可接受的。
- 如果一个节点是可接受的，那么完成它后，瞪眼法看它一段时间，它是显然的。
- 如果第X个节点是显然的，那么第X+1个节点是可接受的。
- 最后一个节点是目标。
后置项目：当你完成此项目时，意味着你掌握了你要学的技能。参考：[[学习方法：降阶法]]

指数目标区别于线性目标。线性目标是最终目标的一部分，而指数目标不是。
换句话说，指数目标是从一阶完成到九阶完成，线性目标是从九阶一级到九阶完成。
![[指数与线性.jpg]]
线性目标序列不可能满足归纳性。只有指数目标序列才有可能。
例如，对于游戏开发，【先做主菜单，再做游戏场景】是线性的。
对于一个技能，比如C#，【先学变量，再学语句，再学流程控制】是线性的。
指数，或者说，阶，有两个性质：
- 完整性：每一个阶都是完整的，不依赖于更高阶或更低阶。每一个阶都可以独立应用。
- 相似性：相近的两阶中存在大量相似（但不同）的东西。

对于C#，以下几个节点是指数的：
- 控制台输出Hellow World
- 在桌面创建一个txt文件，并在其中写入Hellow World
- 将桌面上A.txt文件的内容复制到B.txt中，并在B.txt文件的末尾追加一行Hellow World
- 每秒在B.txt文件的末尾追加一行Hellow World，直至按下空格键。

问：这不就是【先学print函数，再学文件写入，再学文件读取与变量，再学流程控制】吗？为什么说它是指数，而【先学变量，再学语句，再学流程控制】是线性？
答：这不是。看图，图中一到九阶，每次新增的内容确实对应九阶的一到九级，但不能只看新增。阶之所以是阶，是因为完整性与相似性。学流程控制，不只学控制，而是学完整的【通过流程控制来实现不停写入】；流程控制之外的写入，与上一阶类似，但不同。如此是指数。
指数学习可以在任何一个阶段停下并收获满足感，而线性学习半路停下会不知所谓、很快遗忘过去学到的东西。
指数学习才能满足归纳性，学生看到下一个任务时会有自信能完成。即：如果第X个节点是显然的，那么第X+1个节点是可接受的。
### 瞪眼法
瞪眼法：盯着一段代码看，直至你觉得它显然。（如果你觉得那段代码写的不好，也可以修改它）
瞪眼法不仅用于编程，也用于数学：盯着一段证明看，直至你觉得它显然。
会做不等于掌握，能判断一段代码/证明是对的、不等于掌握。显然才等于掌握。要使用瞪眼法来让会做/判断变为显然。
如果瞪到一半发现【为什么不XXX】或【如果XXX会怎样】，那么提问，导师回答。这里就是【会做/判断】与【掌握】的关键差距所在。（修订者注：可惜一般教师不会回答，反而批评学生胡思乱想这么多干嘛。瞪眼法需要学生与教师都理解才行，而不能只有一方理解）
同样，上一段也揭示了瞪眼法时要做什么：要思考【如果不这样，那么还能怎么样】。瞪眼时要确认的，或者说，所谓掌握所真正掌握的，就是【其他办法都不对】，而【会做/判断】是指【这个办法是对的】。
更本质的说：判断是指【它是对的】，掌握是指【只有它是对的】或【只有它与XX是对的，从它与XX中任意采用一种】。（修订者注：或【只有XX下的东西是对的，它属于XX】）
### UI Toolkit
我正在学习Unity UI Toolkit。最终目标：创建扫雷关卡编辑器面板，包括网格、按钮。
由于我们熟悉web与Unity，因此我们可以直接高阶开始。但也尽量做到【每一步都尽可能完整】。
最终的目标序列是：
- 前台背景：创建一个全屏UI画布，左侧是深灰色，右侧是浅灰色。
- 前台左侧：在左侧绘制一个网格。（不可点击）
- 前台右侧：在右侧绘制一些按钮。（不可点击）
- 后台：实现后台的存档数据结构。
- 前后内存读：基于后台数据，显示左侧网格。右侧按钮切换视距与前后台视图。
- 前后内存写：写入与取消雷。写入与取消开启格子。前台视图重置。
- 前后硬盘读写：设置名称，存档，显示关卡网格，点击读档，未保存提示。
- 外壳封装：将以上作为一个场景，封装起来。
看似是线性的，实际上有一点指数性：在前后内存读环节，过去的前台代码有一些会被废弃。【前期做的不全是后期的一部分】是指数与线性的重要区别。
为了保证每一步的完整性，自然要舍弃少量复用性。
并且，在使用指数学习法时，明确步幅很重要。步幅是指一个人能接受的跨度。每个人的步幅都不同，基础好的可以以更难的东西为一阶，基础差的要以简单的东西为一阶。

在使用降阶瞪眼法时还有一点需要注意：这一系列目标，并不是【我来凭借已有知识完成它们】，而是【我来凭借已有知识、查资料能力、提问能力来完成它们】。越高阶要查的东西越多。
如果在执行中没有做到【如果一个节点是可接受的，那么完成它后，瞪眼法看它一段时间，它是显然的】，而是完成一阶之后直接进入下一阶，那么你可能发现【前面都简单，但从某一阶开始突然变难、无法接受、做不下去了】。这也是指数的一个特点：从拐点开始突然暴涨。
### 回顾
本文从降阶瞪眼法讲到UI Toolkit，也是一个指数式讲解。
指数式的特征是：
- 完整性：A与B看似无关。A与B都独立存在，互不依赖。
- 递进性：B难。A简单。有了A之后，B简单。
单独满足递进性的，是线性。满足递进+完整的，是指数。
题外话：所谓天赋，本质就是指数式基础。例如，一个会降阶瞪眼法的人，学习编程快，就会被他人称为【拥有编程天赋】。（修订者注：天赋可后天提高。天赋本质是有意识或无意识的思维方法）
### 人脑原理
问：人是如何学习的？为什么线性学习时半路中断会遗忘历史、而指数学习不会？为什么【只有它对】的应用效果比【它对】强得多？为什么【我能完成下一阶】的自信很重要？
答：
所谓自信重要，本质是【自信能完成、执行后成功完成下一阶】时的喜悦重要。情绪会加深印象。喜悦来自于学习机制【70%置信的事情被验证】。
所谓【只有它对】重要，本质是【要目标则需它】重要，这个联想规则是【目标→它】，所以容易调用。而【它对】的联想规则是【它→目标】，无法调用。调用时只有目标，要基于目标而联想它，而不是基于它而联想目标。
线性学习空闲下来时潜意识会自我反思，自我整理。过去的东西无法被整理出有意义的新东西，无法与大脑中其他东西组合，因此被抛弃。指数学习的历史充斥着满足，满足带来回味并再次满足，正面情绪的因都是有意义的、保留。
（修订者注：三个问题的答案对应三个机制：学习机制，生成判断中生成的联想机制，记忆库整理机制。）