### 总述
一个游戏项目包括下面这些岗位。一人可以兼任多个岗位。
- 一名总负责人：控制进度。吞吐中心，每天阅读每个人的提交结果，给每个人布置任务。推荐：一次性给每个人布置【从项目开始到项目结束的所有任务】，并在每一次阅读提交结果后、在此人后续任务中补充一些新任务。使用软件布置任务。
- 一名游戏策划师：立项第一步，游戏策划师给出游戏类型、玩法亮点、玩家时间线。
- 一名细节策划师：并行。阅读游戏策划案，设计世界观细节、大量道具、以及道具的细节数值。
- 一名UI设计师：并行。阅读游戏策划案，设计所需的UI面板布局草图，设计UI面板具体内容。
- 一名美术设计师：并行。阅读游戏策划案，设计概念图，设计场景草图，设计所需的美术素材。
- 一名编程架构师：立项第二步，阅读游戏策划案，划分模块，设计后台数据结构、指令、事件。
	- 助手：AI工程师。完成AI相关逻辑
	- 助手：编译工程师。完成符文相关逻辑
- 一名编程工程师：立项第三步，基于架构，开发程序。数值、UI、美术，都收束于此。
- 一名视频设计师：并行。基于游戏策划案，设计宣传视频节奏。
- 一名视频剪辑师：立项第四步，基于程序与视频设计案，录制视频，剪辑发布。
	- 助手：素材制造者。基于程序与视频设计案，录制视频。
	- 助手：账号运营者。回复粉丝的消息。
- 一名向上对接者：与第二步并行，阅读游戏策划案，书写商业计划书，联系投资人。了解政府要求，应对政府审查。
	- 助手：论文书写者。联系学术机构。为商业计划书提供说服力。
- 一名水平对接者：与第四步并行，发布Steam游戏，运营官方账号并发布项目侧更新日志与月报，接受媒体采访。
- 一名向下对接者：与第四步并行，管理粉丝群，管理粉丝论坛，发布玩家侧更新日志与月报。
### 编程工程师
- 基于游戏策划案与编程架构案，完成任务并提交。
- 提问：任务描述不清晰。（并具体指出哪里不清晰）
- 提议：数据结构需要修改，因为【不修改也行，但修改后扩展性之类的更好】或【不修改就无法实现最终效果，因为XXX】。
	- 注意：修改数据结构时必须先提议，不可以悄悄改。如果负责人在睡觉，那么：如果你很自信你的改动好，那么就提议后直接执行；如果你不自信，那么可以先做其他工作。
- 提议：最终效果需要修改，因为【实现这个最终效果需要很高的成本，而修改后成本低、且不打多少折扣】或【我提出的新效果设计会让用户更喜欢】。
- 提议：任务中的时间安排需要延长，因为【这个功能看上去简单，但实际上因为XXX而无法简单解决（例如：上传文件看上去简单，但实际上因为丢包的问题而需要分割切片发送与整合）】或【这个功能我本以为做X就能实现，但做X时发现还需要Y，做了Y又需要Z】。
- 每天，在软件中报告你的工作内容，包括做了什么、还差什么要做。并将【还差】的更新到置顶里。
	- 一种报告格式是：【已完成的：XXXX。未完成的：XXXX】。（待办列表）
	- 一种报告格式是：【已完成的：简单：XX。中等：XX。复杂：XX。未完成：XX】。（用于避免【你看上去做的条数多，实际上很多工作都很简单。你的工作量不高】的批评。当面对批评时，你可以说【看我那些标注为复杂的工作，如果你需要的话，我可以解释它为什么复杂。如果你在一个月中抽查三次，我都能解释，那么你就不该质疑我的划分标准，并基于“我今天完成了复杂工作或多个中等工作”而不批评我】。）
	- 报告不仅是给别人看，也是给自己看。自己在工作中应当持有一个笔记，里面记录所有已完成与未完成的事情，并在每次完成时更新笔记。每日结束时将笔记的最终状态发布到软件。
- 不定期书写文档，记录你的重要成果，发布在软件文章社区（也可以同步到自己的自媒体），帮助团队其他人提升实力。例如封装了某些库函数/类库，例如使用了某种思想解决了某个bug/难以实现的功能，例如踩了某个坑（发现某个东西不符合直觉）。
- 有家者：工资八千到三万，工作时间下午三点整到晚上十点整，周一到周六上班。
	- 午休：下午五点到六点、晚十点到十一点，可以去食堂用餐（也可以微信通知送饭到岗位、自愿工作），不安排工作。平时有咖啡机、饮水机、泡面香肠卤蛋鸡爪、自热米饭、自热火锅等。可以早到并自愿工作。
	- 放假：春节四天（调休至八天），国庆三天（调休至七天），劳动节两天（调休至五天），元旦一天（调休至三天），清明一天（调休至三天），端午一天（调休至三天），中秋一天（调休至三天）。
	- 加班：通常无加班。会议在工作时间内（午三晚十，除5-6点），团建使用工作时间。
	- 罚款：缺勤、迟到、早退。（午三晚十、一周六天）
	- 对赌：可以不线下上班，但要保证能做到如下要求。轻度违约则罚款20%（超时50%以内、月延迟回复三次以内、迟到或缺席会议一次以内），重度违约则罚款50%且三个月不得对赌。
		- 按时完成任务。在接受任务之前可以对任务本身的时间安排提出质疑，接受后需要按时完成。
		- 及时回复消息。在工作时间，对于消息，在一分钟内响应。
		- 线下参与会议。提前一天通知第二天在工作时间内有某个会议，第二天线下参与。
		- 正常提问提议。线上会导致提问提议成本高，不可因此而导致【某些你本会提问提议的东西不再提问提议】，有问题则应当在线提问或线下交流。
### 向下对接者
- 作为管理员/版主，管理粉丝QQ群与官网论坛，维持良好氛围，例如删除违规言论、闲聊、组织活动（例如抢楼、抽奖、比赛）。
	- 注意：可以申请活动经费，不过奖励最好是用游戏内道具，这样不仅可以省钱、还可以提高粉丝的纯度（例如，如果冠军奖品是一个笔记本电脑，那么可能会有很多路人也来参赛，奖品被外人拿走）。
	- 注意：你可以对比赛与奖品提出自己的想法建议，例如【建议：在游戏中增加XX道具，以它作为奖品，这样可以既让粉丝想要、又不破坏游戏平衡】。
- 对粉丝中在团队眼里的有价值信息进行收集、整理、报告，包括bug反馈、改进意见、调查问卷、现状例报（每周报告一次当前社群的氛围，包括氛围基调、每日发言人数、每日发言条数、发言风格统计、总人数、流失人数等）、以及收集其他你认为对团队有帮助的信息。
	- 注意：你需要给粉丝良好的反馈，从而维持粉丝积极性。不能只收集后就不管粉丝了，不能让粉丝感觉【送出去的信息石沉大海】。如果一个粉丝提交了一个建议，然后他当天收到【已转达给设计团队】的回复，第三天收到【经过讨论，我们认为XXXX，预计在下个版本实装】，第十天收到【由于XX原因，这个版本没有采纳，我们预计将其修改为XX，并在再下个版本实装它】，一个月后收到【您上次的XX建议已经实装啦，#截图#，感谢您的反馈。这是给您的礼包码：XXXX，感谢您对风神界游戏开发的贡献，祝您游戏愉快！】，进了游戏后发现在更新日志感谢名单上看到【XXX版本更新：1.2.3.……感谢XX、XX的改进意见】中看到了自己的名字，那么他的积极性会暴涨、大概会成为死忠粉。
	- 注意：如果你不知道某个改动的具体进度，那么先阅读开发日志，如果开发日志中没写到它，那么你可以对团队提问。提问时最好整理多个改动的问题一起提问（从而减少开话题数量、节约分析的启动成本。启动成本：回复这种问题，需要设计团队加载相关记忆、分析、回复，每一次加载记忆都是高启动成本。启动成本高，但维持成本低。题外联想：不仅是这种问题，平日里的工作中也有启动成本的概念：开始工作难，但工作了之后维持简单，这也是启动成本问题。任何工作都是：尽量减少启动次数，用单次长维持代替多次短维持。我们反对番茄工作法（番茄：干25分钟休息5分钟），鼓励【一天从早干到晚，从睁眼干到闭眼，吃饭都在工位上】，但允许【最低能耗模式工作】，例如，你可以在工位上玩游戏、刷视频，但你必须自我认同为“我是在工作，我刷视频是为了研究视频设计理论、增强对学习机制的理解”。就像是开车，开车也是启动成本高，所以老司机在面对红灯时都会远远的减速、让车以一种最低速度前进，等到绿灯时加速，保证车永不熄火）。
	- 注意：最好学习编程，可以使用Python脚本来自动统计数据、自动生成现状例报（这样顺带可以做到日报），可以使用GPT来自动写脚本（但GPT的代码会有细节错误，需要你手动微调，这需要你有编程常识）。
	- 注意：除了你主动报告之外，你还需要回应团队对粉丝社群的提问。当然，如果你主动报告做的好，那么提问会很少、甚至没有提问。
- 对团队中在粉丝眼里的有价值信息进行收集、整理、公布，例如更新日志（现在）、月报年报（过去）、开发规划（未来）。
	- 注意：你可以对开发团队提问，但需要使用【预测法】来提问。预测法：你先阅读开发日志、并熟练试玩游戏，之后按【我计划更新日志这样写：XXXX。但我有几处不确定的：1.XXX。2.XXX】的格式提问。
- 学习：使用谷歌、B站、知乎、GPT、图书等方式，阅读论坛管理技巧的相关内容，学习与实践。
	- 注意：如果你在实践中因为【没有正确理解与执行书上的技巧】或者【书上的技巧是错误的，你相信了它】等原因而弄乱论坛、遭遇负反馈，那么：如果你能做到立刻反思出错误的本质（不广不狭。狭：本质找的不够，你即便改了也依然会犯错，例如把失败归因为他人或环境。广：本质找的太广了，你改了是不会犯错，但有许多正确的事情你也不会做了，例如因噎废食）、确信下次不再犯此错，并在现在努力补救（即便最终依然流失30%玩家），那么我们可以宽恕你的错误（因为将你视为长期合作伙伴、你的进步更重要）。题外话：这对你而言也是一个很宝贵的机会，百万元难买，能有一个实践环境给你练手。（但也注意，如果我看不到你的未来，觉得你犯错后还会再犯，那么你犯大错后将被撤职、甚至被追究责任）
	- 注意：你可以在软件内书写并发布文章。例如：
		- 学习笔记：书本上给出了某管理技巧，你对其有效的原因做了进一步的拆解、并优化完善这个管理技巧的细节。
		- 实践感悟：你应用某管理技巧时，遇到了某小的负反馈，你立刻改进、修复。你将这个过程记录下来，反思【为什么会出现那个负反馈】【为什么我没发现】【为什么我的改进方法有效】【我是怎么想到这个改进方法的】。
- 团队内沟通，了解《风神界》的历史、现状、未来，对不了解的地方使用【预测法】提问。预测法：你先阅读网页与软件内的文档，之后按【我猜：风神界的历史/现状/未来是XXX。对于这个猜测，我有几处不自信的地方：1.XXX。2.XXX。这几处我猜的对吗？如果不对，那么真相是什么？】的格式提问。
	- 注意：明确未来，是为了让你有目标、动力、盼头，即便你不是作为项目的推进者（而是维护者）、依然可以在等待的过程中感受到【未来在逐渐成为现实】而兴奋。随着时间的推移，如果你觉得团队的发展路线偏离了【未来】，那么你随时可以提出质问，质问包括【规划是否变了】以及【路线是否偏离了规划】。
	- 你可以对团队提议，例如：论坛设计不合理，有XX缺点，建议增加/删除/修改XX功能来弥补。
	- 你可以对团队提问，例如：为什么游戏设计是XXX？为什么论坛设计是XXX？并预测一个答案：是因为XXX吗？（即便你明知道你的预测是错误的，也要表达出来。这是为了便于回答者理解你究竟哪里不理解、以及便于增强你的预测能力：当你绞尽脑汁预测时，你的预测能力会增长，未来预测的会越来越接近真相。）
	- 你会加入一个QQ群、一个软件社区。QQ群用于闲聊，软件社区用于有复用价值的重要提议、或对QQ群内重要消息的整理；当你参与的QQ群内的重要话题结束时，你将其核心结论整理到软件内。
### 附：无休工作
工作的启动成本高，维持成本低。
你纯娱乐休息后，就不想启动工作；但你启动工作后，你并不抗拒维持工作。
基于此，我们鼓励【全年全天维持工作，永不休息】。
但是，人是肉长的、不是机器，人会疲惫，人需要休息。对此，我们使用【最低能耗模式工作】来休息。
即，你可以做一些【低功耗、低收益】的事情，但一定要有收益，而不能无收益、纯娱乐。

你可以刷视频，但你必须自我认同为【我是在工作，我刷视频是为了研究视频设计理论、增强对学习机制的理解】。
你可以玩原神、然后说【这是为了了解开放世界游戏的玩法，从而更好的理解风神界】。
你可以提议一起去游乐园玩一天，并且说【大家都累了，需要做一些低功耗的工作。去游乐园是低脑功耗的，而且可以在随机环境中观察团队中其他人的行为反应、从而更好的互相理解】。
你可以对你的理由说谎，因为我们相信在“思想论证法”的理论下、谎言将变为真相。（但不可以对事实说谎，例如，不可以玩了但说没玩、不可以在别人靠近的时候你瞬间切屏回到工作界面。）
思想论证法：如果你想成为某性格的人，那么你只需要相信你是那个性格的，并在他人质疑你时你给出理由来论证你就是那个性格的，那么久而久之你自然就是那个性格的了。

如果你想提高描述能力，并且去阅读、思考、执行训练，那么这不属于工作，因为它跟你的工作职责（向下对接）的关系不清晰。
但你可以说：提升描述能力与反思能力，虽然短期对工作无用，但长期可以让我能解决社群环境中的各种突发意外，以及提前消除诸多隐患。
这样，提高描述能力就属于工作了。

如果你想读新闻，那么这不属于工作。
但你可以说：随机获取时事信息，可以让我更好的预测社会未来的变化，从而提高洞察【未来大环境的变化对团队的重大影响】的概率。
这样，读新闻就属于工作了。

一件事你找不出来合理原因的话就不允许做。不要让别人帮你找原因，你必须自己找出合理的原因。
因为，只有你自己找原因，思想论证法才会有效，我们才会容忍你对原因的谎言。

问：什么时候表达理由？是每一次进入低功耗时都要表达【我要做XX、理由是XX】吗？这样也太麻烦了。
答：你可以以二级信息（自言自语话题）的形式在软件内表达，也可以不表达、只需要你自己心里想清楚。他人可以随机抽查提问，比如看你在玩游戏，那么等你一局结束后问你【有什么收获吗】，你需要能回答上来；或者你平时自己写文档，记录你在低功耗模式下的收获，他人对你的提问就会变少。
### 变声器：向下对接者
变声器的向下对接者需要做的工作类似于风神界向下对接者。区别仅在于增加了客服相关的工作：
- 售前客服：亲自熟练使用变声器，阅读开发日志与提问，了解变声器的过去、现状、未来。阅读话术文档，登录淘宝客服（有电脑版与手机版），回应购买者在购买前的提问。
	- 注意：工作时间内，你需要在15秒内响应客户的提问。（对于核心成员：线下办公、无休工作，从睁眼到闭眼都必须要15秒内响应，因此你低功耗工作时无法玩沉浸式的游戏。但你可以找其他人帮你替班，或者低频率的在不忙的时候公开声明【接下来两小时我将做一些低功耗高沉浸的工作】，并退出客服软件（这样就不会给你分配任务了，只会给其他客服分配））
	- 注意：你可以写一个常见问答的手册，并提议【给淘宝设置快捷回复，并在欢迎语里加入常见问题介绍】，这样节约你的工作压力。
	- 注意：如果你感兴趣且有时间，那么可以做一些高成本的事情，比如炼一个AI并写一个脚本来自动回复，再比如提议【不使用淘宝，而是使用一个自己开发的购买与客服工具（例如，集成到软件内）】并自己完成（或声明会负责）这个功能的核心代码（从而避免【你提了一个对我而言高成本低收益、对你而言低成本高收益的建议。你有换位思考吗？】的批评。你完成核心代码后，对于建议的倾听者而言、成本就低了，且你的高成本也表达了你的诚意）。本条优先级很低，可以不做。
- 售后技术支持客服：当客户遇到bug时，远程帮忙解决，并将bug报告给开发团队。如果无法解决，那么转接给其他技术人员。
	- 注意：平日空闲时你可以学习软件安装所需的知识，例如计算机原理，并书写学习笔记文档、发布在文章软件内。
	- 注意：你也可以尝试实践安装各种难以安装的东西，例如从github安装SD（AI绘画工具）、从github安装与使用RVC变声工具、从github安装与使用SVC变声工具。当你能独立从github安装明白这三个东西的时候，几乎一切售后问题你都能独自解决了。不过新手的话估计一个也安装不了，那么你可以先尝试安装一些简单的东西，比如从github安装WinSpy++（windows窗口管理小工具）、Mindustry（开源2D自动化+塔防+RTS游戏）。
- 客服主管：在自己能熟练作为售前与售后客服后，对新招聘来的客服们做培训（招聘本身不用你负责。但你有能力有意愿负责的话更好），监督客服们完成工作，并给客服们考核评价（指标包括：客服回复及时率（15秒内回复）、对客服的差评率、咨询者成交率等）
	- 注意：建议你书写一份客服手册（在线文档。可以发布在文章软件与官网内），发放给所有客服，不定期更新。之后在手册的基础上指导每个客服理解手册。这样效率最高。
	- 注意：空闲时间你可以从谷歌、B站、知乎、GPT、图书等途径了解客服主管所需的知识与技巧，学习招聘与管理手段，书写学习笔记、实践运用。
### 论文书写者
- 将生成判断理论相关的文章改写为论文并投稿。包括：
	- 解释创新类论文。对于XX心理学效应，传统的解释理论是XXX，但这无法解释为何存在此效应的反例。我们使用了一种新的解释，这个解释预言在XX情况下可以稳定复现反例，并且此预言得到实验证实。（投SCI）
	- 效应创新类论文。实验发现：当在XX的条件下XX时，大多数人会XXX。（投SCI）
	- 范式创新类论文。对于心理学/认知科学/人工智能，传统的研究方法有ABCD，但各有缺陷。我们提出了一种新的研究方法，可以解决那些缺陷。但我们的新方法也有不足之处，对此我们使用XX辅助修复。读者可能有XX质疑，对此我们的回复是XXX。（投SCI）
	- 生成判断论论文。自引十多篇解释创新类论文，结合范式创新类论文，提出更底层的解释：生成判断理论。此理论预言多种现象，引用数篇他人论文、自引十多篇效应创新类论文来证实预言成立。（投CNS）
- 联系大学、医院等学术机构，合作实验。
	- 学术机构的主要帮助有：伦理审查、实验经费、被试征召。次要帮助有：论文修改指导、论文投稿时以其人脉地位给主编打招呼。
	- 联系方式可以是直接发送合作邮件，展示我方能力、提出合作方案。方案中可以出让通讯作者，或者交替一作。
	- 联系方式还可以是先从大学官网中了解人员基本信息、锁定教授、然后阅读他的论文、邮件评论、长期交流；熟络之后再提出合作。也可以是直接搜关键词找论文，然后选择作者履历高的，邮件评论。
	- 可以提问【我推荐评论这篇论文，因为作者研究方向与我们接近/因为论文观点与我们类似。这篇论文的大致内容是XXX，我的初步想法是评论XXX，但这个评论有XX缺点。如何修改我的评论？或者，你能否丢弃我的评论、直接给出一个满足XX性质的评论？】
- 阅读论文、图书，书写学习笔记文章，例如：
	- 心理学现象集：存在某些现象，具体来说实验是XXX，对此学术界的解释有XXX。
	- 神经科学实验集：介绍一些神经科学中的经典实验事实，如裂脑人、HM病人。
	- 观点集：某大佬认为XXX（与我们的观点类似），其理由为XXX。
	- 基础科普：例如心理学研究范式；脑神经常识。
- 书写工作笔记文章，例如：
	- 学术界客观与主观规则：例如职称评级标准、论文审查虽然匿名但有各种方法绕过。
	- 当前心理学/认知科学的研究热点，以及历史研究热点的风向、对风向变化的原因的猜测
	- 盘点心理学/认知科学的重要期刊，并对每个期刊介绍其大致风格与几个代表文章
- 书写生成判断理论图书。
	- 收集、整理、分类、修改众多研究文档，设计图书目录。对于【想改动、但不确定是否可以改】的地方提问。
	- 书写内觉文档：对于某个案例，内觉得到某思维过程。写完后可以提问【能否给我露一手，展示一下更高级的内觉会得到什么？】，浊浪逝风或执悲今厄会给出一个【比文档中所描述出来的念头深一层的念头】，从而让作者能看懂。（深两层与两层以上会看不懂。看懂：别人说出来后自己能判断出的确有那个念头，但别人不说的话自己说不出来）
	- 书写生成判断文档：对于某个案例，在内觉后，可以进一步结合更多案例的内觉结果、使用生成判断理论统一解释。可以提问【生成判断理论无法解释这些内觉结果。我尽力解释的结果是XXX，但我的解释无法回应XX质疑】。
	- 提问：我对生成判断的理解是XXXX，但这个理解下我有一个问题：它如何避免XX现象的发生？亦或者，XX现象是存在的？（对于【生成判断如何解释XX现象】的提问方式，见于上一条）
### 身份账号
文章软件，你只需要关注三个东西：
- 注册与登录。在软件内注册一个账号后，告诉我，我后台会修改你的权限，然后你登录。
- 文章社区/更新列表/文章发布。文章社区里你可以阅读所有人的文章，更新列表里会按更新顺序报告文章社区的改动记录，你在文章发布页写文章。
- 话题。你在这里加入【变声器项目交流】社区，你可以阅读、新建、发布话题。发布的时候注意设置话题权限为【阅读：所有作者。发言：所有作者。置顶：所有作者。修改：所有作者】。
	- 高复用价值的东西放在话题里。例如QQ群内重要讨论中的结论的整理，例如一些你分享的重要新闻摘要、工具。（分享新闻的时候不要只甩链接，要用你自己的语言概括主要内容、使得读者即便不看链接也能了解这个新闻。很感兴趣的读者再进入链接看原文。）
	- 当同时谈论多个事情时，使用话题，一个事情一个话题。否则都用QQ群的话，群消息会很乱。
	- 话题可以在话题列表中置顶，每个人独立空间。对于一些长期的重要话题（例如新闻分享话题），置顶。也可以提议开一个分享社区，专门放分享的新闻、技术文章、素材网站、实用工具等。
	- 话题内部有一个置顶区，所有人共享空间，这里是用于放置例如【当前待办工作】【当前还需要回复的问题】【话题结论总结】之类的内容的地方。
	- 话题内部有一个笔记区，每个人独立空间，这里是用于放置例如【我先发送A，当你回复之后我再说B】中的B的地方。
QQ群，你只需要关注一个东西：
- 项目群。例如变声器群、风神界群。在这里你可以问一些希望被迅速回复的问题，以及一些提问简单回答简单的问题。三五百字的大问题用文章软件的话题，并在QQ通知对方回复。云团AI变声开发团队QQ群：（修订者注：已隐藏）
### 如何回复本文
当我将本文发给你时，你不该回复【我能做到这些要求】。
我文档中这么多要求，你单纯一句【能做到】，实在没有说服力，我没法相信你能做到。你需要给出证据，你应该说【我能做到这些要求，因为XXX】。
你之所以说【能做到】，真实理由往往是【你并不反感这些要求，没有理由表明你不会做】，但这并不能证明你能做到这些要求，这只能证明【你在面对外界因你没做到这些要求而给出的督促与责骂时会承受并努力改正，而不是委屈或反抗】。这并不是我要的。
#关键词/内觉/为什么说能做到
我并不会督促你。如果你做不到，那么你就不合格。我要的不是【你不会主动不做】，而是【你会做】，即【你不会主动不做、也不会自动不做】。

怎么证明你能做到？三条路：
- 第一条路：你不会主动不做，也不会自动不做。你有强大的自律能力，有各种自律方法，会自我监督，会每天观察自己的工作、反思自己做的是否正确、规划第二天的工作，在反思与规划中保证本文的所有要求都实现。
- 第二条路：你有做到类似要求的经验。例如你在其他公司任职过、其要求类似于本文；再例如你有过【面对大量全新要求，即便你不理解，也成功实践落实，并在工作中逐渐感悟理解】的经验。
- 第三条路：你深刻理解本文。例如，你早就思考过工作模式的问题，设计过类似的方案（附上你当初的草稿），本文比你的设计更加完善，这是你梦寐以求的完美工作制度；再例如，你尝试基于本文、还原本文背后的思想，使得【基于那个思想、可以推导出本文的这些条目】，你把你还原的思想与各条目的推导发出来（你大概会有一些条目推导不出来，可以在表达你对其他条目的还原与推到后对你不理解的条目提问，这里的提问不扣分、反而加分，因为意味着你的理解能力强）。

问：什么叫【尝试基于本文、还原本文背后的思想】？
答：就是降阶法。见于：[[降阶法：易错点]]。
第一步是思考：如果你来设计【向下对接者】的岗位职责，那么你会怎么设计？（忘掉我的文档）
思考之后，对比你的答案与我的文档，然后思考：哪个更好？如果我的更好，那么你的按照怎样的思路来修改、才可以更接近我的那个？

问：原本我对此比较抵触，以完成任务的心态去思考。但在思考中，我的灵感越来越多。我一边思考自己的方案，一边结合您的文档反复印证，您的文档总能在我思路枯竭时眼前一亮，给我开启新的思路，并且我会顺着您给我的新思路来想到更多的内容，并且短时间多次的【本以为想尽了、没想到还有新思路】的经历导致我极度兴奋，仿佛进入了顿悟状态，甚至创造了大量新的思路。对于我如今设计的方案，我自我感觉全方位超越了您的文档，无论是在价值还是高度上（高度：整个项目的运营层面，而不仅是对接粉丝）。我今天一天兴奋的研究这个问题，写了17000多字的草稿，目前已经接近收束（收束：我的灵感如泉涌、一个还未记录就又冒出来三五个新的，前中期越冒越多，但中后期开始逐渐减少、记录的速度比新出的速度快，此为收束），稍后我会将其重置为一版正文。我这是降阶法中的什么情况？
答：非常好。
你是超速降阶：直接在脑内超速完成了【第一阶（设计）、第二阶（对比、改进）、第三阶（对比、改进）……】，并且完美实现了降阶法的目标：基于一个优秀的东西，迅速抵达与其同级甚至超越它的层次。
这是降阶法的大成，通常需要在监督下使用降阶法拆解十个左右的案例、实时指导纠正，才能做到这个水平。（或者独立拆解一百个案例并反思）
你能第一次就做到这个，是因为你平时善于思考，善于描述。你平日的文档中能将你的观点与事实给清清楚楚的描述出来，并且有许多自己的观点（不论内容如何），你这样的人使用降阶法时就可以一日大成。
不仅是对本文。对任何一个【你能读懂的、高知识密度的、优秀的文章】，你都能在使用降阶法时进入这个【顿悟状态】。
注：我上一行中括号里说的三个条件必须都满足。
- 你能读懂：高密度前沿数学文档不满足标准。
- 高密度：新闻分析不满足标准。一篇新闻分析只有一个结论。
- 高知识密度：三国重大事件表不满足标准。这是高信息密度。信息是基础，知识是推导，缺信息如【巧妇难为无米之炊、空有将才无兵可用】，缺知识如【手握重兵却大败而归】。信息是外在的，知识是内在的。
- 优秀：一个人提出来一堆观点、你部分持反对意见，不满足标准。
### 对本文的评论
仙世凡生：
金句：这只能证明【你在面对外界因你没做到这些要求而给出的督促与责骂时会承受并努力改正，而不是委屈或反抗】。
好本质、深刻、精确的描述！确实是这样，我能感受到他们回答的【能做到】不是真的能做到，但我描述不出来【能做到】和【真的能做到】的区别。但看到执悲今厄的这个描述后，我可以判断出来这就是对【假的能做到】的正确描述！
怎么想到的这个描述？内觉吗？啊， 真的会存在这样复杂的念头吗……（可不内觉的话是怎么想到的？灵感？）

浊浪逝风：
应该是存在的。我虽然在代入后也内觉不到这个描述，但可以内觉到在说【能做到】之前、在检查各个条目时、所谓【这个条目没问题】、本质上微思考的是【尝试涌上一种抗争的情绪、发现想不到理由去延续、于是情绪消散、判定为这个条目没问题】。基于此，【在最终说【能做到】之前、有【你在面对外界因你没做到这些要求而给出的督促与责骂时会承受并努力改正，而不是委屈或反抗】的念头】有一定的可信度。但那一定是更快的，毕竟我的观察能力大约在0.01秒级别（对一个0.1秒的判断，我能将其拆为十步并观察到），执悲今厄说的那个应当是在0.001秒以下的，并且那个几乎必然不是以文字的形式存在的、只是被执悲今厄翻译为文字；毕竟0.01秒级别就已经不是文字了（如我所言的：抗争的情绪）。

执悲今厄：
浊浪逝风说的不错：的确先涌上情绪后消散。的确非文字。
在说【能做到】之前，念头是：逐条看完后，整体检查，涌上情绪并尝试构造反例、失败，检查通过。涌上的情绪是：对于一个高大的暗影，其如魔鬼一样张牙舞爪，指着一本书，数落我的罪责。我在颤抖中持剑大喝壮胆，想要说话，但说不出来。剑落在地上，我跪在地上，是我错了。恶魔在狂笑，我无悲无喜，默默改正。我承诺，我会遵守那本书上的规定。

浊浪逝风：
好像确实有这样的念头。而且这个念头符合记忆索引理论：对于曾经在学校中有被教师批评的经历的学生，教师的表现会类似这里的恶魔，随着记忆的搅拌，在数年后会形成这样抽象的恶魔形象作为索引，这样学生会在记忆中有这个抽象的恶魔事件。那么如今在说【能做到】之前，不需要构造这个复杂的恶魔，只需要调用记忆中的恶魔就够了，这大大佐证了【这个念头是可以存在的，其成本不高】。

仙世凡生：
（啥？这真的不是执悲今厄玄幻小说看多了之后出现的幻觉吗？为什么我内觉不到……不过逻辑上确实可以通过这个恶魔念头得出那个金句。一定是我太菜了Orz）

暮已归人：
执悲今厄内觉的那个恶魔的描述很好，细节很全面，可以修改一下作为小说正文了。
一般的作者会丢失很多细节，例如【恶魔在狂笑】后立刻说【我承诺做到】，这样丢失【无悲无喜，默默改正】后味道会立刻少很多。
执悲今厄的那个描述是【在保证味道下的最小描述】，一句不多一句不少，值得拆解学习。
并且那一段话中多次反转：
- 降：恶魔在咆哮（暗示：我要屈服）
- 升：我不屈服（暗示：我要击败恶魔）
- 降：我错了（暗示：我要被杀）
- 降：恶魔在狂笑（暗示：我要被杀）
- 平：我平静。没被杀也没反抗（暗示：结束）
- 升：我承诺（昂头倔强）
四次反转。（我能内觉到这些暗示，我内觉能力也很强）

仙世凡生：
这个我可以判断出来，我确实有你说的这些暗示中的念头！（不过，如果你不说这些暗示中的念头的话，我没内觉到这些念头。你的内觉能力比我强）
（555，想起来一句话：每个团队都需要一个笨蛋，这样其他人才会觉得自己很棒。难道我就是这个笨蛋？）

浊浪逝风：
暮已归人上面描述的那些暗示中的念头是0.1秒级别的。
一般人的内觉能力在5秒级别。（五秒成默念。只有形成默念、才会被表意识观察到。例如面对困境思考当下怎么办，如果不立刻以分析的形式默念思考【当下的情况是什么？】、而是直接思考怎么做，那么，如果所有念头都小于5秒，那么人会觉得自己是【沉思一分钟后突然想出来答案，没有任何过程，这一分钟就是单纯大脑空白】；而如果有念头大于五秒，那么几乎必然会形成默念【要不要做XXX？】，此时才会被表意识观察到。念头在重复生成中才会被优化得足以用正确的语言文字来描述。）
仙世凡生的内觉能力大约在0.5秒级别。这已经超越普通人太多了。