## 封面
作者：执悲今厄
时间：2024.8.30
## 摘要
传统的投资人使用Pre模型来投资。
本文提出了曲线模型。在曲线模型中，投资人单方面要决定三个参数：
- 耐心年限。你要在多少年内获得回报？
- 谨慎修正。如果一款游戏有10%概率在你的耐心年限后获得百倍回报，那么你最多愿意拿出你可投资资产的多少比例来玩？
- 预测修正。如果计算出来你的股权非常低（比如万分之一），那么你是希望调整置信度？还是希望对计算结果进行开方甚至开三次方？
被投资人要证明的是一个：
- 曲线与置信度。给出在不同投资款下公司在投资人耐心年限下的净利润所构成的曲线，并论证这个曲线的置信度。
明确这些之后，就可以按照公式计算出投资人的投资方案与股权了。

对我们公司的投资要使用曲线模型。
## 关键词
#关键词/投资
#关键词/曲线模型
## 正文
### Pre模型
传统的投资人使用Pre模型来投资。
Pre模型的思想是：先计算你的公司的估值，再根据我的投资款与投资后公司估值的比例来决定我的股权。
例如，我对你的公司的估值是500万。那么我投500万，占股50%；或者我投250万，占股33%。
注：250/(250+500)=33%，500/(500+500)=50%。

Pre模型只适用于被投资公司是成熟稳定的的情况。
基于Pre模型的投资，低风险，但通常也低回报。
### 曲线模型
曲线模型的思想是：先估算你在我的各个投资款下所能带来的盈利曲线，再找出盈利与投资的比值最高的点来根据置信度计算收益，如果收益为正、那么在此投资。
例如，我对你的公司的盈利曲线的估算是：
![[函数.png]]
置信度是0.1。表示【对每个点：有10%的概率实现】。
其中：
A点是回报率最高的点，即【净利润差/投资款】最大。（净利润差：此点的Y减去X为0的点的Y）
C点是回报额最高的点，即【净利润差-投资款】最大。
B点是投资款不超过【自己可投资资产×置信度/谨慎修正】的情况下，回报额最高的点。
注：谨慎修正通常为1或3。1表示相信【10%成功率的事情，我做十次，必成功一次。失败的话我认了】，3表示相信【10%成功率的事情，我做30次，必成功一次。失败的话我认了】。
对于曲线上任意一点（通常是ABC三者之一），计算此点的【F(投资款/(净利润差×置信度), 预测修正)】，这就是自己在此投资款下要的股权。
如果X小于10%，那么F(X,Y)=(10×X)^Y/10
如果X大于等于10%，那么F(X,Y)=X
预测修正通常为1或0.5，表示【凡是大于0而小于10%的，都被视为大分母数。对于大分母数，超出基准的比例部分要取其大数修正的幂次的值。修正值越小、效果越强，1表示无修正】。
- 预测修正为1，表示视为不存在大数修正，例如：
	- 投资一百万，有10%概率你们盈利一亿，那么我要获得10%股权(100w/(1e×10%))，达成时分红收获一千万。
	- 投资一百万，有10%概率你们盈利一万亿，那么我要获得十万分之一股权(100w/(1we×10%))，达成时分红收获一千万。
	- 注：即便大数修正为1，总期望也是正的。例如对于盈利一亿的情况，即便没盈利一亿，也可能盈利一千万。
- 预测修正为0.5，表示如果股权低于10%、那么低出的比例要取开方的值，例如：
	- 投资一百万，有10%的概率你们盈利一亿，那么我要获得10%股权(((100w/(1e×10%))/10%)^0.5×10%)，达成时分红收获一千万。
	- 投资一百万，有10%的概率你们盈利一万亿，那么我要获得千分之一股权(((100w/(1we×10%))/10%)^0.5×10%)，达成时分红收获十亿。

投资人可以自行决定的有：
- 耐心年限。即曲线纵轴中的年限。上表是两年，表示投资人要在两年内获得回报。
- 置信度评估。投资人可以对被投资人的盈利曲线的置信度进行评估，也可以对曲线修改后评估。
- 谨慎修正。谨慎修正应当是一个适用于所有项目的参数，锚定投资人本身，而不锚定项目。
- 预测修正。预测修正也是一个锚定投资人本身的参数。预测修正本质是【置信度应当比自己估算的更低，但大脑无法理解低于1%的置信度的含义，因此置信度不能低于1%、因此直接对计算结果开方修正】。
（注意：置信度表示的不是【被投资人的成功率】，而是【基于被投资人表达出来的信息，永恒中一切可能表达为此信息的项目中，成功的项目的比例】）

投资人与被投资人要讨论的就是曲线函数与曲线置信度。曲线受到如下因素影响：
- 项目成功后的收益
	- 项目所在市场的大小
	- 项目在市场中的竞争力
- 项目在年限内成功的概率
	- 项目难度
	- 团队实力
	- 团队应对意外的能力
	- 项目成本与团队资金
### 各类项目曲线
在对数图下，对于公司，一切单调递增曲线都是S型的。因为横轴前期的影响必然小、且前中后期不可能一直小、后期也不能无限大。
不过，有的公司的曲线可能不是单调递增的。通常是来自于管理能力不足、又不愿放权，所以【钱越多，人越多，越乱】。不建议投资这种公司。

S曲线可以分为这几类：
- 负起点S曲线：X为0时Y为负数。常见于初创公司、研究型公司，暂时没有盈利项目；或者烧钱抢市场的公司，暂时的亏损换来未来的收益。
- 扁S曲线：起点与终点的Y坐标相差不大（两个数量级以内）。这种公司是Pre算法的适用范围。
- 双S曲线：有两个曲线图，置信度不同。公司进可激进、低概率高收益，退可平稳、高概率低收益，两套方案，见机行事。
- 高终点S曲线：当S曲线趋向于平稳时，Y的绝对值极高（百亿以上），Y相比于X的比例极高（千倍以上）。

我们的项目是：双S曲线，两个都是负起点高终点，一个终点百亿、一个终点万亿。
百亿：无AGI的社会性游戏，十年收益百亿。
万亿：AGI。
### 修订：置信度曲线
原文介绍的是【投资款-收益】曲线，置信度固定。
此外，还有一种曲线：【收益-置信度】曲线，投资款固定。