### 逻辑记忆能力
逻辑记忆能力，是指对有逻辑的事情的记忆能力。
逻辑记忆能力强的人，依然会记不住电话号码，找不到钥匙。但上千本书只读一遍、运用自如，一个话题压栈十层、轻松回栈，万行代码脑内演算、没有漏洞。
（压栈：见于软件文章【人际交流：水平交流与垂直交流】）
如何提高逻辑记忆能力？提高脑容量吗？并不是。逻辑记忆能力强的人，脑容量并不高，毕竟依然记不住电话号、找不到钥匙。
逻辑记忆能力的关键，在于外置记忆。不要用大脑来记东西，要用地球来记东西。

读书，不要去读知识，要读【知识的存在】。
比如读艺术读到【正空间、负空间】，没读懂，也不需要去读懂。只需要知道【留白是一种学问】，知道【在画画时，存在一种留白的技巧，在某些时候用了会有好的效果】，至于具体怎样的技巧、什么时候用、怎样的效果，不知道，也不需要知道。
这样的记忆是不是很简单？读一遍就能记住。而且一点不耽误使用：未来如果某天你要画画，或者鉴赏他人的画作，你觉得画的不太好，但说不出哪里不好，那么这时候你自然就会联想到【是不是留白有问题】，并去详细查查正负空间相关的资料。
现实是开卷考试，要让地球去帮你记忆，不要把所有东西都堆到脑子里。脑子里只需要知道【知识的存在】就够了，没必要知道内容，等用的时候再去从地球获取内容。
有的人可能问：既然是从地球获取知识，那么为什么还要知道存在呢？不读书不也一样吗？
对此，回答是：不读书，不知道存在，你在需要用的时候就不知道【这是需要用的时候】。

一个外置记忆的人，会厌恶口头交流（喜欢线上交流）。因为口头交流没有查资料的时间，没法调用地球。
一个外置记忆的强者，在口头交流时的表现可能还不如凡人。
反过来也一样：一个口头交流能力强的人，通常都不擅长外置记忆。
### 脑内演算
写代码，不要去记代码（当然也不要只管写），要印证。
【如果你从头写，那么写出来的代码会与现在的代码一样】，这就是印证。如此你就记住了代码，且能够脑内演算。
不一样怎么办？那就修改现在的代码。
前期的改动会非常频繁且多，后期会慢慢改的越来越少。
代码大约两天就会忘。那么两天改一次。
后期依然两天就忘，但没关系，不需要改，也不需要记。当需要处理某个模块的时候，想一下【如果我做这个模块，那么我会怎么做】，你想的结果就是现实，如此瞬间回忆起一切，或者说，再造出一切、印证出一切。
并且，这个办法并不是在后期才有收益。在中期，再造的与现实有50%一致时，就已经很有用了，可以帮你节省大量的脑力（迅速启动工作。一般人面对海量遗忘的代码时启动工作很难）、以及察觉大量的bug（现实与再造不一致，多半是现实代码有bug）。

印证再造有一个问题：可能第X次印证的时候删除大量的东西，然后第X+5次印证时发现之前删掉的东西可能有的有用。
怎么办？不删？不删的话代码会违背印证（印证时新构造的代码是没有那些本该删除的东西的）。
对此有一个好工具：Git。Git会记录你的每一次改动，它不会忘记任何历史，且你可以全历史的搜索某些东西。
如此就可以放心的在印证时大量删除了。如果删错了，那么可以从git中找回。
git比回收站强得多，git允许全历史搜索、允许查看单个文件的所有改动历史。而且git扩展出的github更是允许【云端、私人、免费、安全、无限容量】的保存你的git历史。（不安全的案例：例如百度网盘可能会审查并删除你的文件。）
（国内无法使用Github。需要使用VPN翻墙）
### 索引与源
知识的存在是索引，知识的内容是源。
压栈时的每一个话题的标题是索引，话题内容是源。
写代码时，需求是索引，代码是源。
逻辑记忆能力，本质是【不要记忆源。要记忆索引，要构造并记忆”索引与源的关系“】。（读书中，关系简单，索引构造难。代码中，索引简单，关系构造难，印证再造时会在潜意识中自动构造出关系）
当你忘记源时，你随时可以通过索引去查找源。

逻辑记忆的一个禁忌，是【源的丢失】。
你知道一个知识在某本书的某一章中，但那本书在一场大火中烧毁了。
你知道我们之前进行过关于X的讨论，但具体讨论的过程与结果是什么、已经随着音波的远去而再也无从知晓了。
你知道在某个文件夹下有一族文件用上万行代码定义了一个强大且完美的模块，你记得那个模块对外提供的接口，但因为硬盘损毁而失去了那个模块的代码。
源不存放在大脑中，大脑中只存放索引与关系。当源丢失时，损失是巨大的、惨烈的。

所以：
- 逻辑记忆者厌恶口头交流，因为它不允许调用外置记忆、且无法外置保存交流本身的源。喜欢线上交流，因为可以调用外置记忆、且会自动将交流本身外置保存在电子设备中。
- 逻辑记忆者厌恶【撤回】【删除】等操作。喜欢github这种保存一切历史的工具（github允许撤回，但github中的撤回是【添加一个新的改动：新的改动是之前的改动的取反】）。
- 上一条衍生：逻辑记忆者厌恶知乎B站的收藏夹，因为其中的源经常被官方销毁。基于此，可以使用自定义程序，遇到好作品、复制链接到程序中、自动下载到本地收藏。

对于下列行为：
- 一个人回看自己中二时期发的QQ空间，非常尴尬，想要将其删除。
- 一个人回看自己过去写的文章，觉得非常蠢，想要将其删除。
- 一个人回看自己与他人的某场对话，觉得自己说错了好几句话，想要将对话历史删除、想要让对方忘记这次对话。
- 一个人犹豫再三，决定还是说出某个发言，然后后悔了，想要撤回。
这些都不会是逻辑记忆者所做的行为。
首先，即便要删除，也会先自己做好备份。
然后，如果面对的对方也是逻辑记忆者，那么出于对对方的尊重、不会销毁对方的源，而是会新增一句【XX消息视为删除（即，不回复你基于XX而对我的提问，且会在你基于XX而提问时对你不满）】。
#自我管理/03超人：记忆能力/逻辑记忆能力/外置记忆：读千本书
#自我管理/03超人：记忆能力/逻辑记忆能力/索引记忆：垂直交流
#自我管理/03超人：记忆能力/逻辑记忆能力/再造记忆：脑内演算万行代码
#自我管理/03超人：记忆能力/逻辑记忆能力/厌恶口头交流
#自我管理/03超人：记忆能力/逻辑记忆能力/厌恶删除与撤回
### 引用
2024.7.3 芳芳
2024.12.6 商业计划书V6.0
2024.12.12 芳芳